<?php

namespace App\Http\Requests\PatrollingLocation;

use App\Http\Requests\BaseRequest;
use App\Enums\PatrollingLocationType;

class UpdatePatrollingLocationRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'sometimes|string|max:255',
            'type' => 'sometimes|in:' . implode(',', PatrollingLocationType::values()),
            'description' => 'sometimes|nullable|string',
            'is_active' => 'sometimes|boolean',
            'wing_id' => 'sometimes|nullable|exists:wings,id',
            'coordinates' => 'sometimes|nullable|string|max:255',
        ];
    }
}