<?php

namespace App\Http\Requests\VehicleLog;

use App\Enums\VehicleLogType;
use App\Enums\VehicleType;
use App\Http\Requests\BaseRequest;
use Illuminate\Validation\Rule;

class StoreVehicleLogRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'vehicle_id' => ['nullable', 'exists:vehicles,id'],
            'guard_id' => ['required', 'exists:users,id'],
            'log_type' => ['required', Rule::enum(VehicleLogType::class)],
            'logged_at' => ['required', 'date'],
            'purpose' => ['nullable', 'string', 'max:255'],
            'visitor_details' => ['nullable', 'array'],
            'visitor_details.name' => ['nullable', 'string', 'max:255'],
            'visitor_details.phone' => ['nullable', 'string', 'max:20'],
            'outsider_vehicle_details' => ['nullable', 'array'],
            'outsider_vehicle_details.vehicle_type' => ['nullable', Rule::enum(VehicleType::class)],
            'outsider_vehicle_details.make' => ['nullable', 'string', 'max:255'],
            'outsider_vehicle_details.model' => ['nullable', 'string', 'max:255'],
            'outsider_vehicle_details.color' => ['nullable', 'string', 'max:255'],
            'outsider_vehicle_details.registration_no' => ['nullable', 'string', 'max:255'],
        ];
    }
}
