<?php

namespace App\Mail;

use App\Models\Visitor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class VisitorApprovalMail extends Mailable
{
    use Queueable, SerializesModels;

    public $visitor;
    public $isApproved;

    public function __construct(Visitor $visitor, bool $isApproved = true)
    {
        $this->visitor = $visitor;
        $this->isApproved = $isApproved;
    }

    public function build()
    {
        $subject = $this->isApproved 
            ? 'Visitor Request Approved' 
            : 'Visitor Request Rejected';

        return $this->view('emails.visitor-approval')
                    ->subject($subject)
                    ->with([
                        'visitor' => $this->visitor,
                        'isApproved' => $this->isApproved,
                    ]);
    }
}