<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PatrolRound extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'start_time',
        'end_time',
        'is_active',
        'description',
    ];

    protected $casts = [
        'start_time' => 'datetime:H:i',
        'end_time' => 'datetime:H:i',
        'is_active' => 'boolean',
    ];

    public function dailyPatrolSummaries(): HasMany
    {
        return $this->hasMany(DailyPatrolSummary::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeOrderByTime($query)
    {
        return $query->orderBy('start_time');
    }

    public function getDurationAttribute(): string
    {
        $start = $this->start_time;
        $end = $this->end_time;

        if (!$start || !$end) {
            return '0:00';
        }

        $diff = $start->diff($end);
        return $diff->format('%H:%I');
    }
}
