<?php

namespace App\Http\Resources;

use App\Models\Owner;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Owner */
class OwnerResource extends JsonResource
{
    public function toArray(Request $request): array {
        return [
            'id' => $this->id,

            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'aadhaar_card' => $this->aadhaar_card,
            'pan_card' => $this->pan_card,
            'photo' => $this->photo,

            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
