<?php

namespace App\Http\Requests\PatrollingLog;

use App\Http\Requests\BaseRequest;
use App\Enums\PatrollingStatus;
use Illuminate\Validation\Rule;

class StorePatrollingLogRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'location_id' => ['required', 'exists:patrolling_locations,id'],
            'guard_id' => ['required', 'exists:guards,id'],
            'patrol_date' => ['required', 'date'],
            'patrol_time' => ['required', 'date_format:Y-m-d H:i'],
            'status' => ['required', Rule::enum(PatrollingStatus::class)],
            'notes' => ['nullable', 'string'],
            'issues_found' => ['nullable', 'string'],
        ];
    }
}
