<?php

namespace App\Http\Requests\Visitor;

use App\Http\Requests\BaseRequest;

class ApproveVisitorRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'approval_notes' => ['nullable', 'string', 'max:1000'],
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'approval_notes.string' => 'Approval notes must be a string.',
            'approval_notes.max' => 'Approval notes cannot exceed 1000 characters.',
        ];
    }
}