<?php

namespace App\Models;

use App\Enums\PatrollingStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PatrollingLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'location_id',
        'guard_id',
        'daily_patrol_summary_id',
        'patrol_date',
        'patrol_time',
        'status',
        'notes',
        'issues_found',
    ];

    protected function casts(): array
    {
        return [
            'status' => PatrollingStatus::class,
        ];
    }

    public function location(): BelongsTo
    {
        return $this->belongsTo(PatrollingLocation::class, 'location_id');
    }

    public function guardUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'guard_id');
    }

    public function dailyPatrolSummary(): BelongsTo
    {
        return $this->belongsTo(DailyPatrolSummary::class);
    }

    public function scopeToday($query)
    {
        return $query->where('patrol_date', now()->format('Y-m-d'));
    }

    public function scopeThisWeek($query)
    {
        return $query->whereBetween('patrol_date', [
            now()->startOfWeek()->format('Y-m-d'),
            now()->endOfWeek()->format('Y-m-d')
        ]);
    }

    public function scopeThisMonth($query)
    {
        return $query->whereBetween('patrol_date', [
            now()->startOfMonth()->format('Y-m-d'),
            now()->endOfMonth()->format('Y-m-d')
        ]);
    }
}
