<?php

namespace App\Http\Requests\PatrollingLocation;

use App\Http\Requests\BaseRequest;
use App\Enums\PatrollingLocationType;
use Illuminate\Validation\Rule;

class StorePatrollingLocationRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'type' => ['required', Rule::enum(PatrollingLocationType::class)],
            'description' => ['nullable', 'string'],
            'is_active' => ['boolean'],
            'wing_id' => ['nullable', 'exists:wings,id'],
            'coordinates' => ['nullable', 'string', 'max:255'],
        ];
    }
}