<?php

namespace App\Http\Requests\Vehicle;

use App\Http\Requests\BaseRequest;
use App\Enums\VehicleType;

class UpdateVehicleRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $vehicleId = $this->route('vehicle')->id;
        
        return [
            'owner_id' => 'sometimes|exists:owners,id',
            'flat_id' => 'sometimes|exists:flats,id',
            'vehicle_type' => 'sometimes|in:' . implode(',', VehicleType::values()),
            'make' => 'sometimes|string|max:255',
            'model' => 'sometimes|string|max:255',
            'color' => 'sometimes|string|max:255',
            'registration_no' => 'sometimes|string|max:255|unique:vehicles,registration_no,' . $vehicleId,
            'photo' => $this->validateFile('photo'),
            'insurance_doc' => $this->validateFile('insurance_doc'),
            'is_active' => 'sometimes|boolean',
        ];
    }
}