<?php

use App\Enums\PatrollingLocationType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patrolling_locations', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type', PatrollingLocationType::values())->default(PatrollingLocationType::OTHER->value);
            $table->string('location_code')->unique();
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->foreignId('wing_id')->nullable()->constrained('wings')->onDelete('cascade');
            $table->string('coordinates')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patrolling_locations');
    }
};